# Business Card Extraction API

This API facilitates the extraction of business card details from images using Google Cloud Vision and OpenAI's language model. The extracted information is returned in JSON format following a predefined structure.

## Installation

1. Clone the repository: `git clone https://github.com/cardflyio/business-card-extraction.git`
2. Install dependencies: `pip install -r requirements.txt`
3. Set up environment variables:
    - `OPENAI_API_KEY`: Your OpenAI API key.
    - `API_ACCESS_KEY`: Access key for API authentication.

## Usage

1. Ensure the required environment variables are set.
2. Start the server by running `python app.py`.
3. Make a POST request to `/business-card-extract` with the following parameters:
    - `apiKey`: Your access key for authentication.
    - `imageUrl`: URL of the image containing the business card details.

### Example Usage

```bash
curl -X POST \
  -F 'apiKey=your-api-key' \
  -F 'imageUrl=https://example.com/business-card.jpg' \
  http://localhost:5000/business-card-extract
```

### Response Format

- #### Success Response (200)

```json
{
  "success": true,
  "data": {
    "address": "123 Anywhere St., Any City, ST 12345",
    "company": "Liceria & Co. Real Estate",
    "email_address": "hello@reallygreatsite.com",
    "job_title": "UI/UX Designer",
    "name": "Mariana Anderson",
    "phone": "+123-456-7890",
    "website": "www.reallygreatsite.com"
  }
}
```

- #### Error Response (4xx, 5xx)

```json
{
  "success": false,
  "data": "Error message here"
}
```
